#include <eval.hh>

#include <ostream>
#include <string>
#include <list>

void
print(std::ostream& os, const result& r);

static void
print_list(std::ostream& os, const std::list<result>& lst)
{
	os << "%(";
	for(std::list<result>::const_iterator i = lst.begin();
			i != lst.end(); ++i)
	{
		if(i != lst.begin()) os << ' ';
		print(os, *i);
	}
	os << ')';
}

void
print(std::ostream& os, const result& r)
{
	if(r.is_eof()) return;
	else if(r.is_string()) os << r.str_;
	else print_list(os, r.lst_);
}
