#include <eval.hh>

#include <istream>
#include <string>
#include <list>

static result
read_special(std::istream& is);

static result
read_internal_word(std::istream& is)
{
	if(!is) return result();
	char c = is.get();
	if(!is) return result();
	if(c == '%') return read_special(is);
	if(c == ' ' || c == '\t') return read_internal_word(is);
	if(c == ')') return result();

	std::string str(1, c);
	while(is)
	{
		char c = is.get();
		if(!is || c == '%' || c == ' ' || c == '\t' || c == ')')
		{
			if(is) is.putback(c); break;
		}
		str += c;
	}
	return result(str);
}

static result
read_internal(std::istream& is)
{
	if(!is) return result();
	std::list<result> lst;
	while(is)
	{
		char c = is.peek();
		if(c == ')') { is.get(); break; }
		result r = read_internal_word(is);
		if(r.is_eof()) throw parse_error("unmatched '('");
		lst.push_back(r);
	}
	return result(lst);
}

static result
read_subst(std::istream& is)
{
	if(!is) return result();
	std::string context, id;
	while(is)
	{
		char c = is.peek();
		if(!is || c == ':') break;
		context += is.get();
	}
	if(!is) return result('%' + context);
	is.get(); // this is ':'
	while(is)
	{
		char c = is.get();
		if(!is || c == ' ' || c == '\t' || c == '\n' || c == '%')
		{
			while(c == ' '|| c == '\t') c = is.get();
			if(is) is.putback(c); break;
		}
		id += c;
	}
	std::list<result> lst;
	lst.push_back(result("lookup"));
	lst.push_back(result(context));
	lst.push_back(result(id));
	return result(lst);
}

static result
read_special(std::istream& is)
{
	if(!is) return result("%");
	char c = is.get();
	if(!is) return result("%");
	if(c == '%' || c == ' ' || c == '\t') return result(std::string(1, c));
	if(c == '(') return read_internal(is);
	is.putback(c);
	return read_subst(is);
}

result
read(std::istream& is)
{
	if(!is) return result();
	char c = is.get();
	if(!is) return result();
	if(c == '%') return read_special(is);

	std::string str(1, c);
	while(is)
	{
		char c = is.get();
		if(!is || c == '%')
		{
			if(is) is.putback(c); break;
		}
		str += c;
	}
	return result(str);
}
