#include <iostream>
#include <string>
#include <stdexcept>
#include <unistd.h>
#include <csignal>

void
send_message(const std::string& addr, const std::string& msg)
{
	std::string buffer;
	std::cout << addr << std::endl;
	getline(std::cin, buffer);
	if(buffer != "vv")
		throw std::runtime_error("why noone wants my message?"
				" I've got '" + buffer + "'");
	std::cout << msg << "^^" << std::endl;
}

void
receive_message(void)
{
	std::string buffer;
	getline(std::cin, buffer);
	if(buffer != "<<" && buffer != ">>")
		throw "something is wrong";
	std::cout << "vv" << std::endl;
	do
	{
		getline(std::cin, buffer);
	} while (buffer != "^^");
}

int main(int argc, char *argv[])
{
	bool send_first = (argc > 1);

	while(true)
	{
		try
		{
			if(send_first)
			{
				send_message(">>", "111\n222\n333\n");
				::sleep(1);
				receive_message();
				::sleep(1);
			}
			else
			{
				receive_message();
				::sleep(1);
				send_message("<<", "555\n666\n777\n");
				::sleep(1);
			}
		}
		catch(const std::runtime_error& x)
		{
			std::cerr << "error: " << x.what() << std::endl;
			std::cerr << "trying again" << std::endl;
		}
	}
	return 0;
}
