#include <dialog.hh>

#include <iostream>
#include <string>
#include <map>

void
dialog::add_button(const std::string& id, const std::string& label, long key)
{
	actions_[++lastaction_] = id;
	screen_ += "[" + label + "(" + lastaction_ + ")]\n";
	buttons_[id] = key;
}

void
dialog::add_label(const std::string& label)
{
	screen_ += label + "\n";
}

void
dialog::add_edit(const std::string& id, const std::string& value)
{
	actions_[++lastaction_] = id;
	screen_ += std::string("(") + lastaction_ + "): {" + id + "}\n";
	values_(id, value);
}

struct replace_value
{
	replace_value(std::string& screen): screen_(screen) {}
	void operator()(const std::string& id, const std::string& value)
	{
		std::string::size_type pos = 0;
		while((pos = screen_.find("{" + id + "}")) != std::string::npos)
			screen_.replace(pos + 1, id.size(), value),
			pos += value.size() + 2;
	}
private:
	std::string& screen_;
};

void
dialog::show(std::ostream& os) const
{
	std::string screen = screen_;
	values_.for_each(replace_value(screen));
	os << screen << std::endl;
}

long
dialog::run(std::ostream& os, std::istream& is)
{
	while(true)
	{
		show(os);

		char c;
		actions_t::const_iterator i;

		while(true)
		{
			os << "\n\n[a..." << lastaction_ << "]: ";
			std::string buffer;
			getline(is, buffer);
			if(buffer.size() > 0) c = buffer[0];

			i = actions_.find(c);
			if(i != actions_.end()) break;
			os << "invalid input {" << c << "}\n";
		}

		buttons_t::const_iterator b = buttons_.find(i->second);
		if(b != buttons_.end())
		{
			return b->second;
		}
		else if(values_.exists(i->second))
		{
			os << "\n\nnew value: ";
			std::string buffer;
			getline(is, buffer);
			values_(i->second, buffer);
			os << "\n\n";
		}

	}
	return -1;
}
