#include <mapper.hh>
#include <xmlscope.hh>

#include <iostream>
#include <fstream>

struct parse_param
{
	parse_param(command& cmd): cmd_(cmd) {}

	void operator()(xml::node& n) const
	{
		if(n.type != xml::node::normal || n.name != "param") return;
		if(n.attrs.find("name") == n.attrs.end()) return;
		std::string name = n.attrs["name"];

		std::string value;
		if(n.prop_exists("value"))
			value = n.prop_get("value");
		else
			value = n.value_get();

		cmd_(name, value);
	}

private:
	command& cmd_;
};

struct parse_attr
{
	parse_attr(command& cmd): cmd_(cmd) {}

	void operator()(const std::string& name, const std::string& value)
	{
		if(name == "name" || name == "id"
				|| name == "key" || name == "match") return;
		cmd_(name, value);
	}

private:
	command& cmd_;
};

struct parse_entry
{
	parse_entry(mapper& m): m_(m) {}

	void operator()(xml::node& n) const
	{
		command cmd("/ctrl/look");
		if(n.type == xml::node::normal && n.name == "file")
		{
			cmd("action", "file");

			if(!n.prop_exists("name")) return;

			cmd("name", n.prop_get("name"));
		}
		else if(n.type == xml::node::normal && n.name == "view")
		{
			cmd("action", "view");

			if(!n.prop_exists("id")) return;

			cmd("id", n.prop_get("id"));
		}
		else return;

		std::string key, match;
		if(n.prop_exists("match"))
		{
			match = n.prop_get("match");
		}
		else if(n.prop_exists("key"))
		{
			key = n.prop_get("key");
		}

		std::for_each(n.attrs.begin(), n.attrs.end(),
					unpair<parse_attr>(parse_attr(cmd)));

		std::for_each(n.nodes.begin(), n.nodes.end(),
					parse_param(cmd));

		m_(key, cmd);
	}

private:
	mapper& m_;
};

bool
load_mapper(const std::string& mapfile, mapper& m)
{
	std::ifstream is(mapfile.c_str());
	if(!is) return false;

	xml::nodes_t data;
	xml::load(is, data);
	xml::process_ns(data);
	xml::process_xi(data, "./", "/");

	std::for_each(data.begin(), data.end(), parse_entry(m));
	return true;
}
