#include <command_set.hh>
#include <dialog.hh>
#include <mapper.hh>

#include <iostream>

bool
load_dialog(const std::string& filename, dialog& d, command_set& c);

static void
look_file(const command& cmd, dialog& d, command_set& c)
{
	d = dialog();
	c = command_set();
	load_dialog(cmd("name"), d, c);
}

static command
look_view(const command& cmd, const mapper& m)
{
	try
	{
		return m.map(cmd("id"));
	} catch(const mapper::missing&)
	{
		std::cerr << "no such id: " << cmd("id") << std::endl;
	}
	return command("/ctrl/look")("action", "quit");
}

static void
look_attr(const command&, dialog&)
{
}

bool
process_cmd(const command& cmd, const mapper& m, dialog& d, command_set& c)
{
	if(cmd.name() == "/ctrl/look")
	{
		if(cmd("action") == "file")
			look_file(cmd, d, c);
		else if(cmd("action") == "view")
			return process_cmd(look_view(cmd, m), m, d, c);
		else if(cmd("action") == "attr")
			look_attr(cmd, d);
		else if(cmd("action") == "quit")
			return false;
	}
	else
	{
		// send it to chooser
	}
	return true;
}
