#include <mapper.hh>
#include <dialog.hh>
#include <command_set.hh>

#include <iostream>

bool
load_mapper(const std::string& mapfile, mapper& m);

bool
load_dialog(const std::string& filename, dialog& d, command_set& c);

bool
process_cmd(const command& cmd, const mapper& m, dialog& d, command_set& c);

void
printp(const std::string& key, const std::string& value)
{
	std::cout << "    <param name=\"" << key
				<< "\" value=\"" << value << "\"/>\n";
}

void
printcmd(const command& c)
{
	std::cout << "  <command name=\"" << c.name() << "\">\n";
	c.for_each(printp);
	std::cout << "  </command>\n";
}

void
printe(const std::string& key, const command& c)
{
	std::cout << "<entry key=\"" << key << "\">\n";
	printcmd(c);
	std::cout << "</entry>\n";
}

struct perform_cmd
{
	perform_cmd(const mapper& m, dialog& d, command_set& c)
		: m_(m), d_(d), c_(c), r_(false) {}

	void operator()(const command& cmd)
	{
		if(r_) return;
		r_ = process_cmd(cmd, m_, d_, c_);
	}

	operator bool() const { return r_; }
private:
	const mapper& m_;
	dialog& d_;
	command_set& c_;
	bool r_;
};

int
main()
{
	mapper m;
	dialog d;
	command_set cmds;

	load_mapper("testmap.xml", m);
	if(process_cmd(command("/ctrl/look")("action", "view")("id", "/"),
				m, d, cmds))
	{
		while(true)
		{
			long result = d.run(std::cout, std::cin);

			if(result >= 0)
			{
				command_set c = cmds;
				if(!c.for_each(result, perform_cmd(m, d, cmds)))
					break;
			}
		}
	}
	return 0;
}
