#include <mapper.hh>

command&
mapper::map(const std::string& viewid, command& cmd) const
{
	map_t::const_iterator i = data_.find(viewid);
	if(i == data_.end()) throw missing();
	return cmd = i->second;
}

mapper&
mapper::add(const std::string& viewid, const command& cmd)
{
	data_.insert(std::make_pair(viewid, cmd));
	return *this;
}

mapper&
mapper::remove(const std::string& viewid)
{
	data_.erase(viewid);
	return *this;
}
