/*
 * xmlscope - minimalistic library for handling XML
 * Copyright (C) 2003 Alexey Voinov <voins@voins.program.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * DESCRIPTION: partial namespaces support
 */
#include <xmlscope.hh>

namespace
{
	typedef std::map<std::string, int> prefixes_t;

	void assign_ns(xml::node& n, int default_ns,
			const prefixes_t& parent_prefixes)
	{
		if(n.type != xml::node::normal)
			return;

		prefixes_t prefixes(parent_prefixes);
		for(xml::node::attributes_t::iterator i = n.attrs.begin();
				i != n.attrs.end(); ++i)
			if(i->first == "xmlns")
				default_ns = n.define_ns(i->second);
			else if(i->first.compare(0, 6, "xmlns:") == 0)
				prefixes[i->first.substr(6)] =
					n.define_ns(i->second);

		n.ns = default_ns;
		size_t pos = n.name.find(':');
		if(pos != std::string::npos)
		{
			prefixes_t::const_iterator ns
					= prefixes.find(n.name.substr(0, pos));
			if(ns != prefixes.end())
				n.ns = ns->second;
			if(n.ns != 0)
				n.name = n.name.substr(pos + 1);
		}

		for(xml::nodes_t::iterator c = n.nodes.begin();
				c != n.nodes.end(); ++c)
			assign_ns(*c, default_ns, prefixes);
	}
}

namespace xml
{
	void process_ns(std::list<node>& tree)
	{
		prefixes_t prefixes;
		for(std::list<node>::iterator i = tree.begin();
				i != tree.end(); ++i)
			assign_ns(*i, 0, prefixes);
	}
}

