#include <iostream>
#include <fstream>
#include <string>

std::string receive(std::istream& is, std::ostream& os, std::ostream& log)
{
	std::string message;
	os << "vv" << std::endl;
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "^^") return message;
		message += buf + "\n";
		log << buf << std::endl;
	}
	log << "-- unexpected eof" << std::endl;
	return message;
}

void wait_accept(std::istream& is, std::ostream& log)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "vv") return;
		log	<< "-- invalid accept line: \""
			<< buf << "\"" << std::endl;
	}
	log << "-- unexpected eof" << std::endl;
}

void send(const std::string& addr, const std::string& msg,
		std::istream& is, std::ostream& os, std::ostream& log)
{
	log << "-- offering this message to \"" << addr << "\"" << std::endl;
	os << addr << std::endl;
	wait_accept(is, log);
	os << msg << "^^" << std::endl;
	log << "-- message sent" << std::endl;
}

int probe(std::istream& is, std::ostream& os, std::ostream& log)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(buf == "<<" || buf == ">>")
		{
			log	<< "-- new message for \""
				<< buf << "\"" << std::endl;
			send(buf, receive(is, os, log), is, os, log);
		}
		else log << "--invalid address line: \""
			 << buf << "\"" << std::endl;
	}
	return 0;
}

int
main(int argc, char *argv[])
{
	if(argc < 2) return probe(std::cin, std::cout, std::cerr);
	std::ofstream os(argv[1]);
	if(!os) return -1;
	return probe(std::cin, std::cout, os);
}
