#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include <sys/wait.h>
#include <signal.h>

using namespace std;

struct channel
{
	int in, out, err;

	channel(int in_, int out_, int err_): in(in_), out(out_), err(err_) {}
};

string
itoa(int n)
{
	ostringstream s;
	s << n;
	return s.str();
}

channel
start_cmd(const string& cmd, const channel& ch)
{
	int in[2], out[2], err[2];
	pipe(in); pipe(out); pipe(err);

	if(!fork())
	{
		close(in[0]); close(out[1]); close(err[1]);
		if(ch.in != 0) close(0), dup2(ch.in, 0);
		if(ch.out != 1) close(1), dup2(ch.out, 1);
		if(ch.err != 2) close(2), dup2(ch.err, 2);
		execl(cmd.c_str(), cmd.c_str(), itoa(in[1]).c_str(),
			itoa(out[0]).c_str(), itoa(err[0]).c_str(), NULL);
		exit(1);
	}
	else
	{
		close(in[1]); close(out[0]); close(err[0]);
		return channel(in[0], out[1], err[1]);
	}
}

void
start_term(const string& cmd, const channel& ch)
{
	if(!fork())
	{
		if(ch.in != 0) close(0), dup2(ch.in, 0);
		if(ch.out != 1) close(1), dup2(ch.out, 1);
		if(ch.err != 2) close(2), dup2(ch.err, 2);
		execl(cmd.c_str(), cmd.c_str(), NULL);
		exit(1);
	}
	else
	{
		close(ch.in); close(ch.out); close(ch.err);
	}
}

int
main(int argc, char *argv[])
{
	if(argc < 2) return 1;
	string cmd, prevcmd;
	channel ch(0, 1, 2);
	ifstream is(argv[1]);
	getline(is, prevcmd); if(!is) return 2;
	while(is)
	{
		getline(is, cmd); if(!is) break;
		ch = start_cmd(prevcmd, ch);
		prevcmd = cmd;
	}
	start_term(prevcmd, ch);
	wait(NULL);
	return 0;
}
