#include <bus_io.hh>

#include <iostream>

static
void wait_accept(std::istream& is, std::ostream& log)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "vv") return;
		log	<< "-- invalid accept line: \""
			<< buf << "\"" << std::endl;
	}
	log << "-- unexpected eof" << std::endl;
}

void send(const std::string& addr, const std::string& msg,
		std::istream& is, std::ostream& os, std::ostream& log)
{
	log << "-- offering this message to \"" << addr << "\"" << std::endl;
	os << addr << std::endl;
	wait_accept(is, log);
	os << msg << "^^" << std::endl;
	log << "-- message sent" << std::endl;
}

std::string receive(std::istream& is, std::ostream& os, std::ostream& log)
{
	std::string message;
	os << "vv" << std::endl;
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "^^") return message;
		message += buf + "\n";
		log << buf << std::endl;
	}
	log << "-- unexpected eof" << std::endl;
	return message;
}

