(on-prev
  (look-view "/printers/connection"))
(on-next 
  ;register local printer here
  (look-view "/printers/vendor"
	     'connection-type "Local"
	     'printer-name (later (get-printer-name))
	     'auto-vendor (later (get-vendor))
	     'auto-model (later (get-model))))
(disable-next)

(define devices (woo-read-names "/printer_detect"))
(define (calculate-current lst)
  (let loop ((lst lst)
	     (num 0))
    (if (null? lst)
      -1
      (let ((is_driver (woo-read (string-append "/printer_detect/" (car lst)) 'driver)))
	(if (> (string-length is_driver) 0)
	  num
	  (loop (cdr lst) (+ num 1)))))))

(define (current-device)
 (string-append "/printer_detect/" (look-attr-get 'devicelist 'text)))

(define (get-vendor)
  (let ((drivername (woo-read (current-device) 'driver)))
    (substring drivername 0 (string-index drivername #\;))))

(define (get-model)
  (let ((drivername (woo-read (current-device) 'driver)))
    (substring drivername (+ (string-index drivername #\;) 1))))

(define (get-printer-name) (look-attr-get 'printer-name text))

(define (can-next) 
  (look-attr 'next-button enabled
	     (if (and (not (null? devices))
		      (> (string-length (get-printer-name)) 0))
	       "yes"
	       "no")))

(vbox sizepolicy "fixed" spacing 2 margin 2
      (hbox sizepolicy "fixed" spacing 1
	    (label "Printer name:")
	    (id 'printer-name (edit "" width 20
				    (on-change (later (can-next))))))
      (label "Available printer devices:" font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
      (id 'devicelist
	  (if (null? devices)
	    (listbox width 30 height 30)
	    (listbox width 30 height 30 (map label devices)
		     current (calculate-current devices))))
  (label "We have tried to made autodetect of your printer.
Click next button if you agree with us, otherwize change default settings"))

