#ifndef	UTILS_FUNCTOR_HH__
#define UTILS_FUNCTOR_HH__

#include <stdexcept>

#include <utils/shared_ptr.hh>

namespace alt
{
	template <typename RetT, typename Arg1,typename Arg2>
	struct functor_impl
	{ /**< general polimorfic functor interface */
		virtual ~functor_impl() {}
		virtual RetT operator()(Arg1,Arg2) = 0;
	};

	template <typename FunctorT,
		  typename RetT, typename Arg1,typename Arg2>
	struct functor_impl_arb: public functor_impl<RetT, Arg1, Arg2>
	{ /**< special interface version for arbitrary functor */
		functor_impl_arb(FunctorT fun): fun_(fun) {}

		RetT operator()(Arg1 arg1,Arg2 arg2)
		{
			return fun_(arg1,arg2);
		}

		FunctorT fun_; /**< internal copy of the functor */
	};

	template <typename RetT, typename Arg1,typename Arg2>
	struct functor
	{ /**< generalized functor for ndk++ callbacks*/
		typedef functor_impl<RetT, Arg1, Arg2> impl_type;
		typedef shared_ptr< impl_type > invoker_type;

		functor() {}

		template <typename FunctorT>
		functor(FunctorT fun):   /**<  initialize with functor type */
				invoker_(new functor_impl_arb<FunctorT, RetT, Arg1, Arg2>(fun))
		{}

		RetT operator()(Arg1 arg1,Arg2 arg2)
		{ /**< run action */
			if (invoker_.get()) return (*invoker_.get())(arg1,arg2);
			throw std::runtime_error("calling empty functor");
		}

		template <typename FunctorT>
		functor<RetT,Arg1,Arg2>& operator=(const FunctorT& fun)
		{
			invoker_.reset(new functor_impl_arb<FunctorT, RetT, Arg1,Arg2>(fun));
			return *this;
		}

		invoker_type invoker_;
	};
}

#endif
