(use-modules (ice-9 popen))

(define (with-input-from-pipe cmdline thunk)
  (let ((saved-iport #f))
    (dynamic-wind
      (lambda ()
	(set! saved-iport (current-input-port))
	(set-current-input-port (open-input-pipe cmdline)))
      thunk
      (lambda()
	(close-pipe (current-input-port))
	(set-current-input-port saved-iport)))))

(define (with-output-to-pipe cmdline thunk)
  (let ((saved-oport #f))
    (dynamic-wind
      (lambda ()
	(set! saved-oport (current-output-port))
	(set-current-output-port (open-output-pipe cmdline)))
      thunk
      (lambda()
	(close-pipe (current-output-port))
	(set-current-output-port saved-oport)))))


;(define (pipe-test)
;  (let ((tmpfile (tmpnam))
;	(str-before "zzz")
;	(str-after ""))
;   (with-output-to-pipe
;    (string-append "cat >" tmpfile)
;      (lambda () (write-line "zzz")))
;    (with-input-from-pipe 
;      (string-append "cat " tmpfile)
;      (lambda () (set! str-after (read-line))))
;    (delete-file tmpfile)
;    (if (string=? str-before str-after)
;      #t
;      #f)))

