(define forward-address ">>")
(define backward-address "<<")
(define exit-address "xx")
(define message-accepted "vv")
(define end-of-message "^^")

(define (valid-addr? addr)
  (or (string=? addr forward-address)
      (string=? addr backward-address)
      (string=? addr exit-address)))

(define (wait-accept)
  (let loop ((line (read-line)))
    (cond
      ((eof-object? line) (error "unexpected eof"))
      ((string=? line message-accepted) #t)
      (else (loop (read-line))))))

(define (write-bus addr message)
  (let ((addr-line (sure-string addr)))
    (if (not (valid-addr? addr-line))
      (error "unsupported address type" addr-line)
      (begin
	(write-line addr-line)
	(wait-accept)
	(write-line message)
	(write-line end-of-message)
	(force-output (current-output-port))))))


;TODO: don't forget about flushing output-port before sending accept
;(write-bus forward-address "message")

