(define ifaces '("aaa" "bbb"))
(define (make-ifacelist)
	  (if (null? ifaces)
	    (id 'ifaces (listbox width 20 height 20))
	    (id 'ifaces (listbox width 20
				 height 20 
				 (map label ifaces)
				 current 0))))

(define (apply-changes)
  (format #t "here:~A" (look-attr-get 'ip text)))

(define (make-ifaceconfig)
  (vbox
    (textbox "some description" width 30 height 6 readonly "yes")
    (hbox (label "IP Address:" width 10)
	  (id 'ip (edit "" width 20 mask "000.000.000.000;_")))
    (hbox (label "Network Mask:" width 10)
	  (edit "xxx.xxx.xxx.xxx"  width 20))
    (button "Apply changes" (on-click
			      (later (apply-changes))))))

;(vbox sizepolicy "fixed" 
;  (label "Available interfaces:")
;  (hbox spacing 1
;    (make-ifacelist)
;    (make-ifaceconfig)))


;(hbox
;(edit "xxx.xxx.xxx") (combobox (map label '(/32" "/31" "/30"))))

(define (forth n) (bit-extract n 0 8))
(define (third n) (bit-extract n 8 16))
(define (second n) (bit-extract n 16 24))
(define (first n) (bit-extract n 24 32))
(define (ones n) (- (expt 2 n) 1))
(define (mask n) (- (ones 32) (ones (- 32 n))))
(define (seq n)
  (let loop ((start 0)
	     (stop n)
	     (result '()))
    (if (< start stop)
      (loop (+ start 1) stop (append result (list start)))
      result)))

(for-each (lambda (x)
	    (let ((m (mask x)))
	      (format #t "~A.~A.~A.~A~%" (first m) (second m) (third m) (forth m))))
	  (seq 32))


