/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <iostream>
#include <fstream>
#include <sstream>

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <command_io.hh>
#include <matcher.hh>
#include <eval.hh>

#include <utils/os.hh>

typedef std::pair<matcher, std::string> script_block_t;
typedef std::vector<script_block_t> script_t;

void
load_script(std::istream& is, script_t& script);

int
usage(void)
{
	std::cerr
		<< "usage: commander <interpreter> <script> init|convert"
		<< std::endl;
	return 1;
}

struct print_matcher
{
	void operator()(const matcher& label) const
	{
		std::cout << label.as_command();
	}
};

void
init(const script_t& script)
{
	std::for_each(script.begin(), script.end(), first(print_matcher()));
}


struct matching
{
	matching(const command& cmd, context& match)
		: cmd_(cmd), match_(match) {}

	bool operator()(const script_block_t& block)
	{
		match_ = context();
		return block.first.matches(cmd_, match_);
	}

private:
	const command& cmd_;
	context& match_;
};


struct append_attr
{
	append_attr(std::string& str): str_(str) {}
	void operator()(const std::string& name,const std::string& value)
	{
		str_.append(" "+name+"=\""+value+"\"");
	}
	std::string& str_;
};

context get_attr_list(const command& cmd)
{
	context ctx;
	std::string list;
	cmd.for_each(append_attr(list));
	ctx("all",list);
	return ctx;
}


void
convert(const std::string& shell, const script_t& script)
{
	context match;
	command cmd;
	std::cin >> cmd;
	script_t::const_iterator i = std::find_if(script.begin(), script.end(),
							matching(cmd, match));
	if(i != script.end())
	{
		evaluator eval;
		eval.functab_["lookup"] = func_lookup;
		eval.ctxttab_["match"] = match;
		eval.ctxttab_["attrs"] = get_attr_list(cmd);
		alt::run_shell(shell, eval(i->second));
	}
}

int
main(int argc, char *argv[])
{
	if(argc < 4) return usage();
	std::string shell(argv[1]);
	std::string action(argv[3]);
	script_t script;

	try
	{
		{
			std::ifstream is(argv[2]);
			load_script(is, script);
		}
		if(action == "init") init(script);
		else if(action == "convert") convert(shell, script);
		else throw std::runtime_error("invalid action");
	}
	catch(const std::runtime_error& x)
	{
		// FIXME: print in woo format
		std::cerr << "shit happened: " << x.what() << std::endl;
		return 2;
	}
	return 0;
}
