/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <eval.hh>

#include <iostream>
#include <sstream>

int
main(int argc, char *argv[])
{
	std::string arg;
	while(--argc)
	{
		arg += *(++argv);
		if(argc > 1) arg += ' ';
	}

	evaluator eval;
	eval.functab_["lookup"] = func_lookup;
	std::istringstream is(arg);
	while(is)
	{
		result r = read(is);
		if(r.is_eof()) break;
		print(std::cout, eval(r));
	}
	std::cout << std::endl;

	return 0;
}
