/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <eval.hh>

#include <list>

result
func_lookup(const std::list<result>& args, const evaluator& eval)
{
	if(args.size() < 2)
		throw eval_error("lookup: 2 args expected");

	std::list<result>::const_iterator i = args.begin();
	result ctxt = eval(*i++);
	if(!ctxt.is_string())
		throw eval_error("lookup: context must be string");

	result id = eval(*i);
	if(!id.is_string())
		throw eval_error("lookup: id must be string");

	std::map<std::string, context>::const_iterator v =
		eval.ctxttab_.find(ctxt.str_);

	if(v == eval.ctxttab_.end())
		throw eval_error("lookup: undefined context");

	return result(v->second(id.str_));
}
