/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <eval.hh>

#include <ostream>
#include <string>
#include <list>

void
print(std::ostream& os, const result& r);

static void
print_list(std::ostream& os, const std::list<result>& lst)
{
	os << "%(";
	for(std::list<result>::const_iterator i = lst.begin();
			i != lst.end(); ++i)
	{
		if(i != lst.begin()) os << ' ';
		print(os, *i);
	}
	os << ')';
}

void
print(std::ostream& os, const result& r)
{
	if(r.is_eof()) return;
	else if(r.is_string()) os << r.str_;
	else print_list(os, r.lst_);
}
