/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <eval.hh>

#include <istream>
#include <string>
#include <list>

static result
read_special(std::istream& is);

static result
read_internal_word(std::istream& is)
{
	if(!is) return result();
	char c = is.get();
	if(!is) return result();
	if(c == '%') return read_special(is);
	if(c == ' ' || c == '\t') return read_internal_word(is);
	if(c == ')') return result();

	std::string str(1, c);
	while(is)
	{
		char c = is.get();
		if(!is || c == '%' || c == ' ' || c == '\t' || c == ')')
		{
			if(is) is.putback(c); break;
		}
		str += c;
	}
	return result(str);
}

static result
read_internal(std::istream& is)
{
	if(!is) return result();
	std::list<result> lst;
	while(is)
	{
		char c = is.peek();
		if(c == ')') { is.get(); break; }
		result r = read_internal_word(is);
		if(r.is_eof()) throw parse_error("unmatched '('");
		lst.push_back(r);
	}
	return result(lst);
}

static result
read_subst(std::istream& is)
{
	if(!is) return result();
	std::string context, id;
	while(is)
	{
		char c = is.peek();
		if(!is || c == ':') break;
		context += is.get();
	}
	if(!is) return result('%' + context);
	is.get(); // this is ':'
	while(is)
	{
		char c = is.get();
		if(!is || c == ' ' || c == '\t' || c == '\n' || c == '%')
		{
			while(c == ' '|| c == '\t') c = is.get();
			if(is) is.putback(c); break;
		}
		id += c;
	}
	std::list<result> lst;
	lst.push_back(result("lookup"));
	lst.push_back(result(context));
	lst.push_back(result(id));
	return result(lst);
}

static result
read_special(std::istream& is)
{
	if(!is) return result("%");
	char c = is.get();
	if(!is) return result("%");
	if(c == '%' || c == ' ' || c == '\t') return result(std::string(1, c));
	if(c == '(') return read_internal(is);
	is.putback(c);
	return read_subst(is);
}

result
read(std::istream& is)
{
	if(!is) return result();
	char c = is.get();
	if(!is) return result();
	if(c == '%') return read_special(is);

	std::string str(1, c);
	while(is)
	{
		char c = is.get();
		if(!is || c == '%')
		{
			if(is) is.putback(c); break;
		}
		str += c;
	}
	return result(str);
}
