(define (woo-query . cmds)
  (write-bus '>> (commands->message cmds))
  (message->commands (read-bus '<<)))

(define (woo-get-option answer option)
  (let ((arg (command-arg-ref answer option)))
    (or (and arg (cdr arg)) "")))

(define (woo-read name option)
  (let ((answer (woo-query `(,name action "read"))))
    (cond
      ((null? answer) '(error "empty answer"))
      ((string-starts-with?
	 (sure-string (command-name (car answer))) 
	 "/error/")
       `(error ,(woo-get-option (car answer) 'reason)))
      ((string-starts-with?
	 (sure-string (command-name (car answer))) 
	 (sure-string name))
       (woo-get-option (car answer) option))
      (else ""))))

(define (woo-read-names name)
  (define (extract-name str)
    (substring str (+ (string-length name) 1) (string-length str)))
  (let ((answer (woo-query `(,name action "read"))))
    (if (null? answer)
      '()
      (call-with-current-continuation
	(lambda (exit)
	  (fold (lambda (x y)
		  (if (null? x)
		    y
		    (let ((cmd-name (sure-string (command-name x))))
		      (cond
			((string-starts-with? cmd-name (sure-string name))
			 (cons (extract-name cmd-name) y))
			((string-starts-with? cmd-name "/error/")
			 (exit `(error ,(woo-get-option x 'reason))))
			(else y)))))
		'()
		answer))))))
  
