(use-translation _ "alterator-users")
(on-apply
  (woo-write "/users/root"
	     "type" "local"
	     "passwd1" (later (look-attr-get 'passwd1 text))
	     "passwd2" (later (look-attr-get 'passwd2 text))))

(on-error
  (later (if (and (global 'reason)
		  (string=? (global 'reason) "passwords mismatch"))
	   (look-view "/chrootpasswd/mismatch")
	   (look-view "/error"))))

(disable-next)

(define (can-next)
  (if (and
	(> (string-length (look-attr-get 'passwd1 text)) 0)
	(> (string-length (look-attr-get 'passwd2 text)) 0))
    (look-attr next-button enabled "yes")
    (look-attr next-button enabled "no")))

(vbox
      (label (_ "Enter new password for system administrator") 
	     font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
      (hbox spacing 1 margin 2
	    (vbox
	      (label (_ "New password:"))
	      (label (_ "New password (re-type):")))
	    (vbox
	      (id 'passwd1 (edit "" echo stars (on-change (later (can-next)))))
	      (id 'passwd2 (edit "" echo stars (on-change (later (can-next))))))))

