(use-translation _ "alterator-users")
(on-error
  (later (if (and (global 'reason)
                  (string=? (global 'reason) "passwords mismatch"))
           (look-view "/useradd/mismatch")                          
           (look-view "/error"))))

(define *users* (woo-read-names "/users"))

;disable next-button if no users yet
(if (null? *users*) (disable-next))

;information title
(define (make-title)
  (let ((userlist *users*))
	(label
	  (if (null? userlist)
	    (_ "No system users yet")
	    (string-append (_ "Already added:") (string-join *users* ", ")))
	  font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")))

(define *auto-login* #t); global variable for auto convertion feature

;auto convertion gecos to some login name
(define (gecos->login str)
  (string-map (lambda (c)
		(case c
		  ((#\space) #\_)
		  (else (char-downcase c))))
	      str))

;are text field of object non empty
(define (non-empty? id)
  (> (string-length (look-attr-get id 'text)) 0))

;add user only if username and two passwd non empty
(define (enable-add)
  (if (and (non-empty? 'username)
	   (non-empty? 'passwd1)
	   (non-empty? 'passwd2))
    (look-attr 'add-user enabled "yes")
    (look-attr 'add-user enabled "no")))

;update login field if auto filling enabled
(define (update-login)
  (list
   (enable-add)
    (if *auto-login*
     (look-attr 'username text (gecos->login (look-attr-get 'gecos 'text)))
     '(/ctrl/look action "ignore"))))

;turn off auto convertion feature
(define (stop-automat)
  (set! *auto-login* #f)
  (enable-add))

;add new user to system
(define (add-user)
  (list
    `(,(string-append "/users/" (look-attr-get 'username 'text))
       action "new"
       type "local"
       passwd1 ,(look-attr-get 'passwd1 'text)
       passwd2 ,(look-attr-get 'passwd2 'text))
    (look-view "/useradd")))
  

(vbox
      (make-title)
      (hbox spacing 1 margin 1
	(vbox
	  (label (_ "User name:") height 3)
	  (label (_ "Login name:") height 3)
	  (label (_ "User Password:") height 3)
	  (label (_ "User Password (retype):") height 3))
	(vbox
	  (id 'gecos (edit "" height 3 (on-change (later (update-login)))))
	  (id 'username (edit "" height 3 (on-change (later (stop-automat)))))
	  (id 'passwd1 (edit "" echo stars height 3 (on-change (later (enable-add)))))
	  (id 'passwd2 (edit "" echo stars height 3 (on-change (later (enable-add)))))))
	(id 'add-user (button (_ "Accept user")
		enabled "no"
		width 20
		(on-click (later (add-user))))))

