(use-translation _ "alterator-network")
(on-error (later (check-error)))
(on-apply (later (made-apply-cmd)))

(define (get-default x) (woo-read "/simple_etcnet/general" x))
(define (get-current x) (look-attr-get x text))

(define (check-error)
  (let ((reason (global "reason")))
    (if (or (string=? reason "wrong address")
	    (string=? reason "wrong name format"))
      (look-view "/net/error" 'next_url "/net/general" 'reason reason)
      (look-view "/error"))))

(define (made-apply-cmd)
  (woo-write "/simple_etcnet/general"
	     'hostname (get-current 'hostname)
	     'domainname (get-current 'domainname)
	     'gateway (get-current 'gateway)
	     'dns1 (get-current 'dns1)
	     'dns2 (get-current 'dns2)))

(define (not-empty? x) (> (string-length x) 0))

(define (check-can-dns2) (if (not-empty? (look-attr-get 'dns1 text)) "no" "yes"))
(define (can-dns2) (look-attr 'dns2 readonly (check-can-dns2)))

(vbox
  (label (_ "General Network Settings") font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
  (vbox margin 2
    (hbox (label (_ "Host Name:") width 10 )
	  (id 'hostname (edit (get-default 'hostname) width 30)))
    (hbox (label (_ "Domain Name:") width 10)
	  (id 'domainname (edit (get-default 'domainname) width 30))))
  (vbox margin 2
    (hbox (label (_ "Default route:") width 10)
	  (id 'gateway (edit (get-default 'gateway) width 30))))
  (vbox margin 2
    (hbox (label (_ "DNS 1") width 10)
	  (id 'dns1 (edit (get-default 'dns1)
			  width 30
			  (on-change (later (can-dns2))))))
    (hbox (label (_ "DNS 2") width 10)
	  (id 'dns2 (edit (get-default 'dns2)
			  width 30
			  readonly (check-can-dns2))))))

