(use-translation _ "alterator-network")
(on-error (later (check-error)))

(define (check-error)
  (if (string=? (global "reason") "wrong address")
    (look-view "/net/error" 'next_url "/net/ifaces" 'reason "wrong address")
    (look-view "/error")))


;general all possible ipv4 netmasks
(define (forth n) (bit-extract n 0 8))
(define (third n) (bit-extract n 8 16))
(define (second n) (bit-extract n 16 24))
(define (first n) (bit-extract n 24 32))
(define (ones n) (- (expt 2 n) 1))
(define (gen-mask n) (- (ones 32) (ones (- 32 n))))
(define (seq)
  (let loop ((start 32)
	     (stop 1)
	     (result '()))
    (if (>= start stop)
      (loop (- start 1) stop (append result (list start)))
      result)))

(define netmasks (map (lambda (x)
			 (let ((m (gen-mask x)))
			   (format #f "/~A    (~A.~A.~A.~A)"
				   x
				   (first m)
				   (second m)
				   (third m)
				   (forth m))))
		       (seq)))


(define ifaces (woo-read-names "/simple_etcnet/ifaces"))


(define (make-ifacelist)
	  (if (null? ifaces)
	    (id 'ifaces (listbox width 20 height 20))
	    (id 'ifaces (listbox width 20
				 height 20 
				 (map label ifaces)
				 current 0))))

(define (selected-iface) (look-attr-get 'ifaces text))

(define (cmd-selected-iface)
  (string-append "/simple_etcnet/ifaces/" (selected-iface)))


(define (default-value x)
  (if (null? ifaces)
    ""
    (woo-read (cmd-selected-iface) x)))

(define (get-default-ip)
    (let ((ip (default-value 'ipv4address)))
      (substring ip 0 (or (string-index ip #\/) (string-length ip)))))

(define (get-default-mask)
  (if (null? ifaces)
    0
    (let* ((ip (default-value 'ipv4address))
	   (pos (string-index ip #\/))
	   (len (string-length ip)))
      (if (not pos)
	0
	(string->number (substring ip (+ 1 pos) len))))))

(define (change-ip)
  (woo-write (cmd-selected-iface)
     'ip (look-attr-get 'ip text)
     'mask (- 32 (string->number (look-attr-get 'netmasks current)))))

(define (make-ifaceconfig)
  (vbox
    (id 'description (textbox (default-value 'description)
			      width 30
			      height 6
			      readonly "yes"))
    (hbox (label (_ "IP Address:") width 10)
	  (id 'ip (edit (get-default-ip) width 20)))
    (hbox (label (_ "Network Mask:") width 10)
	  (id 'netmasks (combobox (map label netmasks)
				  current (- 32 (get-default-mask))
				  width 20)))
    (button (_ "Apply changes")
	    enabled (if (null? ifaces) "no" "yes")
	    (on-click (later (change-ip))))))

(vbox sizepolicy "fixed" 
  (label (_ "Available interfaces:"))
  (hbox spacing 1
    (make-ifacelist)
    (make-ifaceconfig)))



