(on-error (look-view "/printers")) ; ignore errors here

(use-translation _ "alterator-printers")

(define printers (woo-read-names "/cups/printers"))
(define (selected-printer) (look-attr-get 'printers text))

(define (selected-printer-cmd)
  (string-append "/cups/printers/" (selected-printer)))

(define (default-value x)
  (if (null? printers)
    ""
    (woo-read (selected-printer-cmd) x)))
(define (printer-to-widget x)
  (look-attr x text (later (default-value x))))

(define (labeled-label name txt)
  (hbox (label txt) (id name (label ""))))

;list of installed printers
(define (make-printer-list)
  (vbox sizepolicy "fixed"
    (label (_ "Installed printers:") font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
    (if (null? printers)
      (listbox width 20 height 20)
      (id 'printers (listbox width 10 height 20 
			     (map label printers)
			     current 0
			     (on-select 
			       (map printer-to-widget '(info default state connection))))))))

(define (printer-name) (look-attr-get 'printers text))
(define (printer-name-cmd)
  (string-append "/cups/printers/" (printer-name)))

(define (made-default)
  (list
    (woo-write (printer-name-cmd) 'default "yes")
    '(/ctrl/cache action reset)
    (look-view "/printers")))

;printer's summary
(define (make-printer-info)
  (hbox margin 3
	(vbox sizepolicy "fixed"
	  (map (lambda (x)
		 (label (_ x) font "-*-*-bold-*-*--*-*-*-*-*-*-*-*" height 3))
	       '("Summary:" "Default:" "Status:" "Connection type:"))
	  (label "" height 3))
	(vbox
	  (map (lambda (x) (id x (label (default-value x) width 30 height 3))) 
	       '(info default state connection))
	  (button (_"Made as default printer") height 3
		  enabled (if (null? printers) "no" "yes")
		  (on-click
		    (later (made-default)))))))

;remove current printer
(define (del-printer)
  (list
    `(,(string-append "/cups/printers/" (look-attr-get 'printers text)) action "delete")
    (look-view "/printers")))

;buttons for add/remove printers
(define (buttons)
  (hbox
    (button (_"Add new printer") (on-click
				(look-view "/printers/connection")))
    (button (_"Remove printer")
	    enabled (if (null? printers) "no" "yes")
	    (on-click (later (del-printer))))))

;main window definitions
(vbox
  (hbox
    (make-printer-list)
    (make-printer-info))
  (buttons))

