(use-translation _ "alterator-printers")

(on-error (look-view "/printers/error" 'next_url "/printers/local"))

(on-prev
  (look-view "/printers/connection"))
(on-next 
  (later (create-printer))
  (look-view "/printers/vendor"
	     'prev_url "/printers/local"
	     'connection-type "Local"
	     'printer-name (later (printer-name))
	     'auto-vendor (later (get-vendor))
	     'auto-model (later (get-model))))
(disable-next)

(define devices (woo-read-names "/printer_detect"))
(define (calculate-current lst)
  (or (list-index
	(lambda (x)
	  (let ((is_driver (woo-read (string-append "/printer_detect/" x) 'driver)))
	    (> (string-length is_driver) )))
	lst) 0))

(define (device-name) (look-attr-get 'devicelist 'text))
(define (cmd-device-name) (string-append "/printer_detect/" (device-name)))

(define (get-vendor)
  (let ((drivername (woo-read (cmd-device-name) 'driver)))
    (if (string=? drivername "")
      ""
      (substring drivername 0 (string-index drivername #\;)))))

(define (get-model)
  (let ((drivername (woo-read (cmd-device-name) 'driver)))
    (if (string=? drivername "")
      ""
      (substring drivername (+ (string-index drivername #\;) 1)))))

(define (printer-name) (look-attr-get 'printer-name text))
(define (cmd-printer-name) (string-append "/cups/printers/" (printer-name)))

(define (can-next)
  (look-attr 'next-button enabled
	     (if (and (not (null? devices))
		      (> (string-length (printer-name)) 0))
	       "yes"
	       "no")))

(define (create-printer)
  `(,(cmd-printer-name) action new local-port ,(device-name)))

(vbox sizepolicy "fixed" spacing 2 margin 2
      (hbox sizepolicy "fixed" spacing 1
	    (label (_"Printer name:"))
	    (id 'printer-name (edit (if (global "printer-name") (global "printer-name") "")
				      width 20
				      (on-change (later (can-next))))))
      (label (_"Available printer devices:") font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
      (id 'devicelist
	  (if (null? devices)
	    (listbox width 30 height 30)
	    (listbox width 30 height 30 (map label devices)
		     current (calculate-current devices))))
  (label (_"We have tried to made autodetect of your printer.
Click next button if you agree with us, otherwize change default settings")))

