(use-translation _ "alterator-printers")
;design todo: need on-timer for waiting end of processing
;temporary hack for testing
(on-error  (look-view "/printers/error" 'next_url "/printers/model"))
(on-prev (look-view "/printers/vendor" 
		    'auto-vendor (global "vendor")
		    'auto-model (if (global "auto-model") (global "auto-model") "")))
;todo: also pass connection summary information
(on-next (later (add-printer-id))
	 (look-view "/printers/summary"
		    'model-name (later (model-name))
		    'printer-name (global "printer-name")
		    'connection-type (global "connection-type")))

(define vendor-models (string-append "/printer_drivers/" (global "vendor")))
(define model-list (sort (woo-read-names vendor-models) string<?))

(define (set-auto-model lst)
  (let ((auto-m (global "auto-model")))
    (if (not auto-m)
      0
      (or (list-index (lambda (x) (string=? auto-m x)) lst) 0))))


(define (model-name) (look-attr-get 'models text))
(define (cmd-model-name) (string-append vendor-models "/" (model-name)))
(define (printer-id) (woo-read (cmd-model-name) 'id))

(define (printer-name) (string-append "/cups/printers/" (global "printer-name")))
(define (add-printer-id) (woo-write (printer-name) 'ppd (printer-id)))

(vbox width 30 height 80 margin 1 spacing 1
  (label (_"Choose printer model:") font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
  (hbox
    (id 'models
	(listbox (map label model-list)
		 current (set-auto-model model-list)))))

