(use-translation _ "alterator-printers")

(on-prev (look-view (global "prev_url")
		    'printer-name (global "printer-name")))
(on-next (look-view "/printers/model" 
		    'vendor (later (look-attr-get 'vendors 'text))
		    'printer-name (global "printer-name")
		    'connection-type (global "connection-type")
		    'auto-model (if (global "auto-model") (global "auto-model") "")))

(define vendorlist (sort (woo-read-names "/printer_drivers") string<?))
(define (set-auto-vendor lst)
  (let ((auto-v (global "auto-vendor")))
    (if (not auto-v)
      0
      (or (list-index (lambda (x) (string=? auto-v x)) lst) 0))))

(vbox width 30 height 80 margin 1 spacing 1
  (label (_"Choose printer vendor:") font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
  (id 'vendors
      (listbox (map label vendorlist)
	       current (set-auto-vendor vendorlist))))

