#ifndef ADMFS_CONDUCTOR_HH__
#define ADMFS_CONDUCTOR_HH__

#include <map>
#include <string>

#include <utils/singleton.hh>
#include <admfs/runtime_info.hh>

namespace admfs
{
    typedef	std::vector<std::string>		dirent_vector;
    typedef	std::map<std::string,runtime_info>	supporter_map;

    class conductor_impl
    {
	public:
	    conductor_impl() {}
	    void list(const std::string&,dirent_vector&);/**< get list of available objects*/
	    std::string type(const std::string&,bool usecache=true); /**< return type of object, if empty then object doesn't exists */
	    bool add_plugin(const std::string&); /**< try to add plugin */
	    void del_plugin(const std::string&); /**< delete plugin */
	    void destroy(const std::string&); /**< destroy some object */
	    bool open(const std::string&,int); /**< prepare information about some object */
	    void truncate(const std::string&,off_t); /**< truncate information buffer */
	    void close(const std::string&); /**< release information buffers */
	    size_t read(const std::string& path, char *buffer, size_t buflen, off_t off);
	    size_t write(const std::string& path, const char *buffer, size_t buflen, off_t off);
	    /**< read buffer content */
	private:
	    /**
	     * mapping: supporter --> runtime information
	     */
	    supporter_map supporters_;
    };

    typedef alt::singleton_holder<conductor_impl> conductor;

}

#endif
