#ifndef ALT_UTILS_DIRSTREAM_HH__
#define ALT_UTILS_DIRSTREAM_HH__

#include <iostream>
#include <utils/dirbuf.hh>

namespace alt
{
	//forward definitions
	template <typename charT, typename Traits = std::char_traits<charT> >
	class basic_dirstream;

	//default definitions
	typedef basic_dirstream<char>	dirstream;

	/**
	 * input directory stream
	 */
	template <typename charT, typename Traits>
	class basic_dirstream: public std::basic_istream<charT, Traits>
	{
		typedef charT	char_type;
		typedef Traits	traits_type;
		typedef typename traits_type::int_type	int_type;
		typedef typename traits_type::pos_type	pos_type;
		typedef typename traits_type::off_type	off_type;

		typedef alt::dir_buf<char_type, traits_type> dirbuf_type;
		typedef std::basic_istream<char_type, traits_type> istream_type;
	public:
		basic_dirstream(const char *path):
				istream_type(NULL),
				dirbuf_(path, std::ios_base::in,BUFSIZ)
		{
			this->init(&dirbuf_);
		}
	private:
		dirbuf_type	dirbuf_; /**< internal read buffer */
	};
}

#endif // ALT_UTILS_PSTREAM_HH__
