(define datadir "../common/")

(load (string-append datadir "pipe.scm"))
(load (string-append datadir "str.scm"))
(load (string-append datadir "command.scm"))
(load (string-append datadir "command-compat.scm"))
(load (string-append datadir "command-pattern.scm"))

;admirals
(define admirals '())

;process each file in directory
(define (directory-for-each dirname proc)
  (let ((dir (opendir dirname)))
    (let loop ((e (readdir dir)))
      (cond
	((eof-object? e) (closedir dir))
	((and (not (string=? "." e))
	      (not (string=? ".." e))) (proc e) (loop (readdir dir)))
	(else (loop (readdir dir)))))))

;read initial data from old fashioned admiral (or commander)
(define (read-init-info)
  (let loop ((cmd (read-command))
	     (result '()))
    (if (null? cmd)
      result
      (loop (read-command) (cons cmd result)))))

;convert throw external old fashioned program (admiral/commander)
(define (ask-old-admiral cmd ctxt) cmd)

;process old fashioned admiral (or commander)
(define (process-old-admiral prg)
  (define (call-old-init prg)
    (with-input-from-pipe (string-append prg " init") (lambda () (read-init-info))))
  (define (make-old-cmd-pattern cmd)
    (make-command-pattern (map sure-string cmd)))
  (map (lambda (x)
	 (cons (make-old-cmd-pattern x) ask-old-admiral)) (call-old-init prg)))


;determine admiral type
(define (new-admiral? prg)
  (with-input-from-file prg
			(lambda ()
			  (let ((a (read-char))
				(b (read-char))
				(c (read-char)))
			    (and (char=? a #\")
				 (char=? b #\:)
				 (char=? c #\"))))))
