/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef CONDUCTOR_HH__
#define CONDUCTOR_HH__

#include <map>
#include <string>

#include <utils/singleton.hh>
#include <plugin_info.hh>

typedef	std::vector<std::string>		dirent_vector;
typedef	std::map<std::string,plugin_info>	supporter_map;

bool valid_path(const std::string& path);
int dir_level(const std::string& path);

class conductor_impl
{
	public:
		conductor_impl() {}
		void list(const std::string&,dirent_vector&);/**< get list of available objects*/
		std::string type(const std::string&,bool usecache=true); /**< return type of object, if empty then object doesn't exists */
		bool add_plugin(const std::string& path,const std::string& plugin_dir="/usr/lib/alterator/backends/"); /**< try to add plugin */
		void del_plugin(const std::string&); /**< delete plugin */
		void destroy(const std::string&); /**< destroy some object */
		bool open(const std::string&,int); /**< prepare information about some object */
		void truncate(const std::string&,off_t); /**< truncate information buffer */
		void close(const std::string&); /**< release information buffers */
		size_t read(const std::string& path, char *buffer, size_t buflen, off_t off);
		size_t write(const std::string& path, const char *buffer, size_t buflen, off_t off);
		/**< read buffer content */
	private:
		/**
		 * mapping: supporter --> runtime information
		 */
		supporter_map supporters_;
};

typedef alt::singleton_holder<conductor_impl> conductor;

#endif
