/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <iostream>
#include <apt-pkg/init.h>
#include <apt-pkg/error.h>
#include <apt-pkg/mmap.h>

int main(void)
{
	try
	{
		if(!pkgInitConfig(*_config)) throw 1;
		if(!pkgInitSystem(*_config, _system)) throw 2;
		if(!_system->LockRead()) throw 3;
		FileFd fd(_config->FindFile("Dir::Cache::pkgcache"),
				FileFd::ReadOnly);
		if(_error->PendingError()) throw 4;
		MMap Map(fd, MMap::Public|MMap::ReadOnly);
		if(_error->PendingError()) throw 5;
		pkgCache Cache(&Map);
		for(pkgCache::PkgIterator P = Cache.PkgBegin(); !P.end(); ++P)
		{
			if(P->VersionList == 0) continue;
			std::cout << P.Name() << std::endl;
		}
	}
	catch(int x)
	{
		_error->DumpErrors();
		return x;
	}
	return 0;
}
