(use-translation _w_ "alterator-acc")

;window definitions
width 80
height 70
;backgroundpixmap "bg-1024x768.png"

;keyword definitions
(declare-keyword number)
(declare-keyword help)
(declare-keyword filename)
(declare-keyword stepfile)

(declare-keyword prev-enabled)
(declare-keyword next-enabled)
(declare-keyword prev-button)
(declare-keyword next-button)

(declare-keyword page)
(declare-keyword step-list)

;wizard specific events definitions
(declare-event on-next)
(declare-event on-prev)
(declare-event on-apply)

;wizard helper functions

;checks for global wizard parameters
(define (global-passing?) (not (global filename)))
(define (with-help?) (and (global help) (string=? (global help) "yes")))

;work with steps
(define (get-steps)
  (define (combine-name x num) (string-append x (number->string num)))
  (let loop ((num 0)
	     (result '()))
    (let* ((stname (combine-name "step" num))
	   (descname (combine-name"description" num))
	   (st (global stname)))
      (if st
	(loop (+ num 1) (append result
				(list (cons (_w_ (global descname))
					    st))))
	result))))

(define steps (get-steps)) ;full step-list
(define current-number (global number)); current step name
(define current-step (list-index (lambda (x) (string=? (cdr x) current-number)) steps))

(define (get-number num) (cdr (list-ref steps num)))

(define (next-step) (get-number (+ current-step 1)))
(define (prev-step) (get-number (- current-step 1)))

;enable/disable buttons
(define *prev-enabled* #t)
(define *next-enabled* #t)
(define (enable-prev) (set! *prev-enabled* #t))
(define (enable-next) (set! *next-enabled* #t))
(define (disable-prev) (set! *prev-enabled* #f))
(define (disable-next) (set! *next-enabled* #f))
(define (prev-enabled?) *prev-enabled*)
(define (next-enabled?) *next-enabled*)
(define (attr-prev-enabled)
  (list 'enabled (if (prev-enabled?) "yes" "no")))
(define (attr-next-enabled)
  (list 'enabled (if (next-enabled?) "yes" "no")))

;real page filename
(define (real-filename)
  (if (global-passing?) (global stepfile) (global filename)))

;create top line with title
(define (wizard-make-title-line) (label (car (list-ref steps current-step))))

;create internal page
(define (wizard-make-step-line)
  (id page (vbox sizepolicy "expanding"
	     (include (real-filename)))))

;go previous step button
(define (wizard-make-prev-button)
  (id prev-button
      (if (global-passing?)
	(button (_w_ "Exit") (on-click look-quit))
	(button (_w_ "Prev") (attr-prev-enabled) (on-click (look-send page 'on-prev))))))

;go next step button
(define (wizard-make-next-button)
  (id next-button
      (if (global-passing?)
	(button (_w_ "Apply") (on-click (look-send page 'on-apply)))
	(button (_w_ "Next") (attr-next-enabled) (on-click (look-send page 'on-next))))))

;create bottom line with buttons
(define (wizard-make-button-line)
  (hbox margin 2 spacing 1
	(wizard-make-prev-button)
	(wizard-make-next-button)))

;window with internal page and navigation buttons
(define (wizard-make-page-window)
  (vbox margin 1
    (wizard-make-title-line)
    (wizard-make-step-line)
    (wizard-make-button-line)))

;current attributes flattened
(define (flatten-globals)
  (fold-right (lambda (x y)
		(let ((first (car x))
		      (second (cdr x)))
		  (if (and (not (string=? first "help"))
			   (not (string=? first "action"))
			   (not (string=? first "id")))
		    (append y (list first second))
		    y)))
	      '()
	      *globals*))

(define (file-content filename)
  (if (access? filename R_OK)
    (with-output-to-string
      (lambda ()
	(with-input-from-file filename
			      (lambda ()
				(let loop ((current (read-line)))
				  (and (not (eof-object? current))
				       (write-line current)
				       (loop (read-line))))))))
    ""))

(define (step-pixmap num)
  (cond ((= num current-step) "step_state_current.png")
	(else "step_state_unknown.png")))

(define (step-labels)
  (fold (lambda (current result)
		(let ((name (car current))
		      (num (length result)))
		  (append result (list (label name pixmap (step-pixmap num))))))
	      '()
	      steps))

(define (can-jump)
  (let ((current (string->number (look-attr-get step-list "current"))))
    (if (= current current-step)
      (look-attr step-list "current" current-step)
      (look-view (get-number current)))))

(define (wizard-make-step-widget w h)
  (id step-list (listbox 
		  width w
		  height h
		  (step-labels)
		  current current-step
                  (on-select (later (can-jump))))))

;window with help and list with available steps
(define (wizard-make-support-window)
  (if (with-help?)
    (vbox margin 2 spacing 1 sizepolicy "fixed"
	  (wizard-make-step-widget 20 30)
	  (textbox (file-content (string-append (real-filename) ".txt"))
		   width 20 height 30 readonly yes))
    (vbox margin 2 spacing 1 sizepolicy "fixed"
	  (wizard-make-step-widget 20 60))))

;pass all errors to subwidget handlers
(on-error (look-send page 'on-error))
(on-dbus (look-send page 'on-dbus))

;widget description
(hbox
  (wizard-make-support-window)
  (wizard-make-page-window))


