Name:		alterator
Version:	1.99
Release:	alt17

Summary:	ALT Linux configurator engine
License:	GPL
Group:		System/Configuration/Other

Source:		%name-%version.tar.bz2

# Automatically added by buildreq on Thu Apr 21 2005
BuildRequires: cook fontconfig freetype2 gcc-c++ glib2 guile16-devel kookish libdbus-devel libdbus-qt-devel libqt3-devel libstdc++-devel pkgconfig xorg-x11-libs

#for install script
Requires: hotplug guile16
Requires: glibc-locales, glibc-gconv-modules

#for backward compatibility
Requires: %name-common = %version-%release %name-look-qt = %version-%release

%description
ALT Linux configurator engine

%package common
Summary: Common ALTerator files and directories
License: GPL
Group: System/Configuration/Other

%description common
Common ALTerator files and directories

%package look-qt
Summary: Graphical qt-based alterator frontend
License: GPL
Group: System/Configuration/Other

%description look-qt
Graphical qt-based alterator frontend

%package -n install3
Summary: Third stage of installer
License: GPL
Group: System/Configuration/Other
Requires: %name = %version-%release
Requires: %name-timezone, %name-users, %name-printers, %name-network, %name-x11
Requires: xorg-x11-xfs

%description -n install3
Third stage of installer

%package -n acc
Summary: ALT Linux Control Center
License: GPL
Group: System/Configuration/Other
Requires: %name = %version-%release

%description -n acc
ALT Linux Control Center

%prep
%setup -q
#replace default common directory
%__subst s,../common/,%_datadir/%name/common/, src/admiral/admiral \
src/rear-admiral/rear-admiral \
src/ensign/ensign \
src/bordbuch/bordbuch \
src/libaltguile/common.cc

#cook bug hackaround
%__subst '/^vc:/d;/^cxxflags:/d;/^ldflags:/d;' \=config

%build
cook -no_list -no_include_cooked_warning -b /usr/share/kookish/main.cook \
	vc=none cxxflags="$RPM_OPT_FLAGS -fPIC -I/usr/lib/qt3/include" \
	ldflags='-Wl,-rpath-link bin' \
	all

%install
#create special directories
%__install -d -m755 $RPM_BUILD_ROOT%_libdir/%name/{backend,backend2,model}
%__install -d -m755 $RPM_BUILD_ROOT%_cachedir/%name
%__install -d -m755 $RPM_BUILD_ROOT%_sysconfdir/%name
%__install -d -m755 $RPM_BUILD_ROOT%_datadir/%name/common
%__install -d -m755 $RPM_BUILD_ROOT%_datadir/locale/ru/LC_MESSAGES/

cook -no_list -no_include_cooked_warning -b /usr/share/kookish/main.cook \
	vc=none cxxflags="$RPM_OPT_FLAGS -fPIC -I/usr/lib/qt3/include" \
	ldflags='-Wl,-rpath-link bin' \
	destdir=$RPM_BUILD_ROOT \
	install

#common scheme data
install -m644 common/* $RPM_BUILD_ROOT%_datadir/%name/common/

#scheme based utils
install -m755 src/admiral/admiral $RPM_BUILD_ROOT%_bindir
install -m755 src/rear-admiral/rear-admiral $RPM_BUILD_ROOT%_bindir
install -m755 src/ensign/ensign $RPM_BUILD_ROOT%_bindir
install -m755 src/bordbuch/bordbuch $RPM_BUILD_ROOT%_bindir


###### install3

pushd install3

#installer startup scripts
%__install -d -m755 $RPM_BUILD_ROOT%_sbindir/
%__install -m755 scripts/startalterator $RPM_BUILD_ROOT%_bindir/
%__install -m755 scripts/install3 $RPM_BUILD_ROOT%_sbindir/

mkdir -p $RPM_BUILD_ROOT%_libdir/%name/scripts
%__install -m644 ui/*.scm $RPM_BUILD_ROOT%_libdir/%name/scripts/
%__install -m644 ui/*.png $RPM_BUILD_ROOT%_libdir/%name/scripts/
%__install -m644 install3.script install3map.scm $RPM_BUILD_ROOT%_libdir/%name/scripts/

#translations
msgfmt po/alterator-wizard.po -o $RPM_BUILD_ROOT%_datadir/locale/ru/LC_MESSAGES/alterator-wizard.mo

popd

###### acc

pushd acc

#acc scripts
%__install -m755 scripts/acc-register $RPM_BUILD_ROOT%_bindir/
%__install -m755 scripts/acc $RPM_BUILD_ROOT%_bindir/

mkdir -p $RPM_BUILD_ROOT%_libdir/%name/scripts
%__install -m644 ui/*.scm $RPM_BUILD_ROOT%_libdir/%name/scripts/
%__install -m644 acc.script accmap.scm accmap2.scm  $RPM_BUILD_ROOT%_libdir/%name/scripts/

#translations
msgfmt po/alterator-acc.po -o $RPM_BUILD_ROOT%_datadir/locale/ru/LC_MESSAGES/alterator-acc.mo

popd

%find_lang %name-wizard --output install3.lang
%find_lang %name-acc --output acc.lang

%post -p %post_ldconfig
%postun -p %postun_ldconfig

%define backend local_users
%define _altdata_dir %_datadir/alterator
%define _altlib_dir %_libdir/alterator

%triggerpostun -n acc -- acc < 1.99-alt17
%__subst 's,acc.scm,/usr/lib/alterator/scripts/acc.scm,
s,accmap2.scm,/usr/lib/alterator/scripts/accmap2.scm,
s,\*.map,/usr/share/alterator/maps/*.map,' /usr/lib/alterator/scripts/accmap.scm

%files
%doc doc/howto.txt doc/cache.txt doc/look-cmd.txt
%_bindir/*
%exclude %_bindir/startalterator
%exclude %_bindir/scm-look
%_sbindir/*
%exclude %_sbindir/install3
%_libdir/*.so.*

%files  -f install3.lang -n install3
%_bindir/startalterator
%_sbindir/install3
%_libdir/%name/scripts
%exclude  %_libdir/%name/scripts/*.png
%exclude  %_libdir/%name/scripts/*acc*
%exclude  %_libdir/%name/scripts/*welcome*

%files -f acc.lang -n acc
%_bindir/acc
%_bindir/acc-register
%_libdir/%name/scripts/accmap2.scm
%config(noreplace) %_libdir/%name/scripts/accmap.scm
%_libdir/%name/scripts/acc.scm
%_libdir/%name/scripts/acc.script

%_libdir/%name/scripts/*welcome*

%files common
%_cachedir/%name
%_sysconfdir/%name
%dir %_libdir/%name
%dir %_libdir/%name/backend
%dir %_libdir/%name/backend2
%dir %_libdir/%name/model
%_datadir/%name
%_libdir/%name/scripts/*.png

%files look-qt
%_bindir/scm-look

%changelog
* Mon Apr 25 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt17
- filesystem improvements

* Fri Apr 22 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt16
- first version of control center

* Thu Apr 21 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt15
- new map format
- new backend format
- added logger (bordbuch)

* Wed Apr 13 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt14
- bugfixes

* Tue Apr 12 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt13
- current snapshot:
  - added x11 step
  - woo-read-names now with caching by default
  - added on-double-click for listbox, on-click for checkbox

* Mon Apr 04 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt12
- alterator-network,alterator-printers now in separate packages

* Tue Mar 29 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt11
- current snapshot:
  -- turned off building of executor/defusator/admfs
  -- added ensign (replacement of conductor based modules)
  -- added dbus support
- users stuff now in separate package named alterator-users

* Mon Mar 21 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt10
- current snapshot:
  - removed obsoleted commander/rcommander/eval/libeval
  - first version of network config
  - include first version of timezone config
  - minor bugfixes
- local_users backend now in separate package

* Mon Mar 14 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt9
- current snapshot:
  -- first version of printers config
  -- minor bugfixes
- added new subpackage install3.

* Fri Mar 04 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt8
- current snapshot:
  -- admiral and rear-admiral instead of commanders
  -- gettext support
  -- useradd step for wizard
  -- many bugfixes

* Thu Feb 24 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt7
- new subpackages:
   - common (common files and directories)
   - look-qt (graphical frontend)
   - admfs (admfs backend system)
- fixed little bug in post/postun scripts
- latest alterator snapshot with wizard engine

* Wed Feb 09 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt6
- new snapshot
- scm-look is now default
- defusator is used instead of executor (fuse disabled)

* Wed Feb 02 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt5
- improved install3 script

* Tue Jan 25 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt4
- removed reqs on kernel-modules-fuse
- added modprobe fuse to start of the script

* Tue Jan 25 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt3
- new snapshot
- not-yet-obsolete docs packaged
- buildreqs fixed

* Thu Jan 20 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt2
- stage3 added
- root passwd changer added

* Wed Jan 19 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt1
- new version.
- old changelog (<=1.0.1) removed.
