;generalized read-script engine
;;;
;;; ALTerator - ALT Linux configuration project
;;;
;;; Copyright (c) 2004,2005 ALT Linux Ltd.
;;; Copyright (c) 2004,2005 Stanislav Ievlev
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
;;; USA.
;;;
(define (read-script filename valid-expr)
  (with-input-from-file filename
			(lambda ()
			  (let loop ((expr (read))
				     (result '()))
			    (if (eof-object? expr)
			      result
			      (cond
				((string? expr) (loop (read) result))
				((valid-expr expr) (loop (read) (append result (list expr))))
				(else (error "invalid config expression:" expr))))))))

;generalized print init info engine
(define (print-init lst)
  (define (to-old-chooser cmd) ;C++ version of chooser cannot work with symbols ;)
    (map (lambda (x)
	   (if (symbol? x) (string-append "^" (sure-string x) "$") x))
	 cmd))
  (for-each (lambda (x) (write-command (to-old-chooser (car x)))) lst))

;general find and eval engine
(define (find-and-eval cmd lst match-proc made-proc)
  (let loop ((lst lst))
    (if (null? lst)
      #f
      (let* ((current (car lst))
	     (match-result (match-proc (car current) cmd)))
	(if match-result
	  (made-proc match-result cmd (cdr current))
	  (loop (cdr lst)))))))
