;barnacle - old mariner (old backend format)
;TODO: add with-locked-file
;Note: in this version I've allowed to write to directories.
;Note: 'new action is same as 'write but with exitance checking

(define (error-mariner reason) (lambda args `(error ,reason)))

(define (barnacle script objects action)
  ;helpers
  (define (type-from-answer answer)
    (let ((pos (string-index-right answer #\space)))
      (and pos (string-ref answer (+ 1 pos)))))
  (define (name-from-answer answer)
    (substring answer 0 (or (string-index-right answer #\space) (string-length answer))))
  (define (args-from-answer answer)
    (let ((pos (string-index answer #\:)))
      (if pos
	(cons (substring answer 0 pos)
	      (substring answer (+ pos 1) (string-length answer)))
	(error "wrong answer from backend, : separator not found" answer))))
  ;actions
  (define (do-list object-name)
    (with-input-from-pipe (string-append script " -l \"" object-name "\"")
			  (lambda ()
			    (read-fold (lambda (x res)
					 (cons (list (name-from-answer x)) res)) '()))))
  (define (do-read object-name)
    (with-input-from-pipe (string-append script " -r \"" object-name "\"")
			  (lambda ()
			    (read-fold (lambda (x res)
					 (let ((splited (args-from-answer x)))
					   (cons (car splited) (cons (cdr splited) res)))) '()))))
  (define (do-write object-name . args)
    ;we have made a sigpipe protected output to backend, and , therefore, ignore possible problems 
    ;in backends. it's possible we will return a error message in the future
    (let ((outport #f))
      (catch #t
	     (lambda ()
	       (with-ignored-sigpipe
		 (lambda ()
		   (set! outport (open-output-pipe (string-append script " -w \"" object-name "\"")))
		   (and (pair? args)
			(for-each (lambda (x)
				    (display (sure-string (car x)) outport)
				    (display #\: outport)
				    (display (sure-string (cdr x)) outport)
				    (newline outport))
				  (car args)))
		   (close-pipe outport)
		   (set! outport #f))))
	     (lambda (key . args) (and outport (close-pipe outport))))))
  (define (do-delete object-name)
    (system (string-append script " -d \"" object-name "\"")))
  (define (do-type object-name)
    (if (string=? object-name "/")
      #\d
      (with-input-from-pipe (string-append script " -t \"" object-name "\"")
			    (lambda ()
			      (let ((answer (read-line)))
				(if (eof-object? answer) #f (type-from-answer answer)))))))
  ;dispatcher
  (let ((object-name (string-join (if (null? objects) '("/") objects) "/")))
    (case action
      ((read) (case (do-type object-name)
		((#\d) (lambda args (do-list object-name)))
		((#\r) (lambda args (do-read object-name)))
		(else (error-mariner "object not found"))))
      ((write) (if (do-type object-name)
		 (lambda args (apply do-write object-name args) #f)
		 (error-mariner "object not found")))
      ((new)  (lambda args
		(apply do-write object-name args)
		(if (do-type object-name) #f '(error "object not created"))))
      ((delete) (lambda args
		  (if (do-type object-name) (do-delete object-name))
		  (if (do-type object-name) '(error "object not deleted") #f)))
      (else (error-mariner "unsupported action type")))))

