(define (woo-query . cmds)
  (write-bus '>> (commands->message cmds))
  (message->commands (read-bus '<<)))

(define (woo-get-option answer option)
  (let ((arg (command-arg-ref answer option)))
    (or (and arg (cdr arg)) "")))

(define (woo-error? cmd)
  (string-starts-with? (sure-string (command-name cmd)) "/error/"))

(define (woo-find-error cmds) (find woo-error? cmds))
   
(define (woo-read name)
  (woo-query `(,name action "read")))

(define (woo-write name . args)
  (woo-query `(,name action "write" ,@args)))

(define (woo-read-names name cmdlist)
   (define (extract-name cmd)
     (let ((str (sure-string (command-name cmd))))
       (substring str (+ (string-length name) 1) (string-length str))))
   (map extract-name cmdlist))

