(use-modules (ice-9 popen))

;extended version of ice-9 popen
(define (read-only? x) (eq? x 'read-only))
(define (write-only? x) (eq? x 'write-only))
(define (read-write? x) (eq? x 'read-write))

;return (pid,read-port,write-port)
;TODO: port other code from ice-9 popen
; e.g. guardian's, hooks, etc.
(define (create-process mode prog . args)
  (let ((read-pipe (and (or (read-only? mode)
			    (read-write? mode))
			(pipe)))
	(write-pipe (and (or (write-only? mode)
			     (read-write? mode))
			 (pipe))))
    (let ((pid (primitive-fork)))
      (cond 
	((= pid 0) ;child work
	 (if (or (read-only? mode)
		 (read-write? mode))
	   (begin (close-port (car read-pipe))
		  (dup2 (fileno (cdr read-pipe)) 1)))
	 (if (or (write-only? mode)
		 (read-write? mode))
	   (begin (close-port (cdr write-pipe))
		  (dup2 (fileno (car write-pipe)) 0)))
	 (apply execlp prog prog args))
	(else ;parent work
	  (list pid
		(if (or (read-only? mode)
			(read-write? mode))
		  (begin (close-port (cdr read-pipe))
			 (car read-pipe))
		  #f)
		(if (or (write-only? mode)
			(read-write? mode))
		  (begin (close-port (car write-pipe))
			 (cdr write-pipe))
		  #f)))))))

(define (stop-process action p)
  (and (cadr p) (close-port (cadr p)))
  (and (caddr p) (force-output (caddr p)) (close-port (caddr p)))
  (if (eq? action 'terminate)
    (kill (car p) SIGTERM)
    (waitpid (car p))))

;(define (test-create-process)
;  (define l (create-process 'read-write "/tmp/ttt"))
;  (define d (create-process 'read-only "ls" "-al"))
;  (define k (create-process 'write-only "/tmp/ttt1"))
;
;  (format #t "~A~%" l)
;  (format #t "read:~A~%" (read-line (cadr l)))
;  (write-line "test" (caddr l))
;  (write-line "test1" (caddr l))
;  (force-output (caddr l))
;  (format #t "read:~A~%" (read-line (cadr l)))
;  (stop-process 'teminate l)
;  (format #t "read:~A~%" (read-line (cadr d)))
;  (stop-process 'wait d)
;  (write-line "test1" (caddr k))
;  (write-line "test2" (caddr k))
;  (stop-process 'terminate k))

(define (with-input-from-pipe cmdline thunk)
  (let ((saved-iport #f))
    (dynamic-wind
      (lambda ()
	(set! saved-iport (current-input-port))
	(set-current-input-port (open-input-pipe cmdline)))
      thunk
      (lambda()
	(close-pipe (current-input-port))
	(set-current-input-port saved-iport)))))

(define (with-output-to-pipe cmdline thunk)
  (let ((saved-oport #f))
    (dynamic-wind
      (lambda ()
	(set! saved-oport (current-output-port))
	(set-current-output-port (open-output-pipe cmdline)))
      thunk
      (lambda()
      	(force-output (current-output-port))
	(close-pipe (current-output-port))
	(set-current-output-port saved-oport)))))

(define (with-ignored-sigpipe thunk)
  (dynamic-wind
    (lambda () (sigaction SIGPIPE SIG_IGN))
    thunk
    restore-signals))

;(define (pipe-test)
;  (let ((tmpfile (tmpnam))
;	(str-before "zzz")
;	(str-after ""))
;   (with-output-to-pipe
;    (string-append "cat >" tmpfile)
;      (lambda () (write-line "zzz")))
;    (with-input-from-pipe 
;      (string-append "cat " tmpfile)
;      (lambda () (set! str-after (read-line))))
;    (delete-file tmpfile)
;    (if (string=? str-before str-after)
;      #t
;      #f)))
