(use-modules (srfi srfi-13) (srfi srfi-1))

;transform symbol to string if we need it
(define (sure-string obj)
  (cond 
    ((symbol? obj) (symbol->string obj))
    ((number? obj) (number->string obj))
    ((string? obj) obj)
    (else (error "unknown object type for sure-string" obj)))) 

;split string into list of substring using separator
(define (string-split str separator . args)
  (let* ((without_trail (and (not (null? args))
			     (car args)))
	 (initial_start (if without_trail
			  0
			  (or (string-skip str separator) (string-length str)))))
	 (let loop ((start initial_start)
		    (end (string-length str))
		    (res '()))
	   (if (>= start end)
	     res
	     (let* ((newpos (or (string-index str separator start) end))
		    (next_start (if without_trail
				  (+ newpos 1)
				  (or (string-skip str separator newpos) end))))
	       (loop next_start
		     end
		     (append res (list (substring str start newpos)))))))))

;predicate - are string starts with prefix
(define (string-starts-with? str prefix)
  (let ((len (string-length prefix)))
    (and (>= (string-length str) len)
	 (string=? (substring str 0 len) prefix))))

;read each line in the input stream, and accumulate results
(define (read-fold proc initial)
  (let loop ((line (read-line))
	     (result initial))
    (if (eof-object? line)
      result
      (loop (read-line) (proc line result)))))

;general quotation engine for the string
(define (string-quote quote-proc str)
  (string-fold (lambda (x y) (string-append y (quote-proc x))) "" str))

;general unquote engine for the string
(define (string-unquote quote-char unquote-proc translate-proc str)
  (let loop ((result "")
	     (start 0)
	     (end (string-length str)))
    (if (>= start end)
      result
      (if (and (char=? (string-ref str start) quote-char)
	       (< (+ 1 start) end))
	(loop (string-append result
			     (unquote-proc (string-ref str (+ 1 start))))
	      (+ 2 start)
	      end)
	(loop (string-append result
			     (translate-proc (string-ref str start)))
	      (+ 1 start)
	      end)))))

