(define forward-address ">>")
(define backward-address "<<")
(define exit-address "xx")
(define message-accepted "vv")
(define end-of-message "^^")
(define unsupported-direction "<>")

(define (valid-addr? addr)
  (or (string=? addr forward-address)
      (string=? addr backward-address)
      (string=? addr exit-address)))

(define (wait-accept addr)
  (write-line addr)
  (force-output (current-output-port))
  (let loop ((line (read-line)))
    (cond
      ((eof-object? line) (error "unexpected eof"))
      ((string=? line message-accepted) #t)
      (else (loop (read-line))))))

(define (write-bus addr message)
  (let ((addr-line (sure-string addr)))
    (if (not (valid-addr? addr-line))
      (error "unsupported address type" addr-line)
      (begin
	(wait-accept addr-line)
	(display message) ;not use write-line to avoid extra #\newline symbols
	(write-line end-of-message)
	(force-output (current-output-port))))))


;TODO: don't forget about flushing output-port before sending accept
;(write-bus forward-address "message")
(define-macro (read-bus-address . args)
	      (let ((read-bus-loop (gensym))
		    (address (gensym)))
		`(let ,read-bus-loop ((,address (read-line)))
		   (cond 
		     ((eof-object? ,address) (error "unexpected eof?"))
		     ,@(let loop ((res '())
				  (args args))
			 (if (null? args)
			   res
			   (let ((current (car args)))
			     (loop
			       (cons `((string=? (sure-string ,(car current)) ,address) 
				       ,@(cdr current)) res)
			       (cdr args)))))
		     (else
		       (write-line unsupported-direction)
		       (force-output (current-output-port))
		       (,read-bus-loop (read-line)))))))

(define (read-bus-message)
  (write-line message-accepted)
  (force-output (current-output-port))
  (let loop ((line (read-line))
	     (res ""))
    (cond 
      ((eof-object? line) res)
      ((string=? line end-of-message) res)
      (else (loop (read-line) (string-append res line (string #\newline)))))))

;read single message from single direction
(define (read-bus addr)  (read-bus-address (addr (read-bus-message))))

;helper: convert bus message to set of commands
(define (message->commands msg)
  (with-input-from-string msg
    (lambda()
      (let loop ((result '())
		 (cmd (read-command)))
	(if (null? cmd)
	  result
	  (loop (append result (list cmd))
		(read-command)))))))

(define (commands->message cmds)
  (with-output-to-string
    (lambda ()
      (for-each (lambda (x) (write-command x)) cmds))))
