/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef COMMAND_SET_HH
#define COMMAND_SET_HH

#include <command.hh>

#include <list>
#include <vector>

class command_set
{
public:
	typedef std::list<command> commands_t;

private:
	std::vector<commands_t> commands_;

public:
	long
	add(const command&);
	
	long
	add(long, const command& );
	
	template <typename A> inline A for_each(long, A);
	template <typename A> inline A for_each(long, A) const;
};

template <typename A> A
command_set::for_each(long ndx, A a)
{
	return std::for_each(commands_[ndx].begin(), commands_[ndx].end(), a);
}

template <typename A> A
command_set::for_each(long ndx, A a) const
{
	return std::for_each(commands_[ndx].begin(), commands_[ndx].end(), a);
}

#endif // COMMAND_SET_HH
