/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef DIALOG_QT_HH
#define DIALOG_QT_HH

#include <dialog-new.hh>
#include <qmainwindow.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qprogressbar.h>
#include <list>
#include <map>

class qt_dialog: public dialog
{
public:
	qt_dialog(QMainWindow *);
	~qt_dialog(void);

	virtual widget * make_button(void);
	virtual widget * make_label(void);
	virtual widget * make_lineedit(void);
	virtual widget * make_textbox(void);
	virtual widget * make_listbox(void);
	virtual widget * make_combobox(void);
	virtual widget * make_checkbox(void);
	virtual widget * make_progressbar(void);
	virtual widget * make_vbox(void);
	virtual widget * make_hbox(void);

	virtual long run(void);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid = "");
	virtual std::string get_attr(const std::string& name);
	virtual widget& insert(widget *);

	virtual void name_it(const std::string&, widget*);
	virtual widget * who_is_it(const std::string&) const;

private:
	widget *remember_pointer(widget *);

	QMainWindow *wnd_;
	QWidget *top_;
	std::list<widget *> ptrs_;
	std::map<std::string, widget *> names_;
};

class qt_widget: public QObject, public widget
{
	Q_OBJECT
public:
	virtual QWidget *get_widget(void) const = 0;
	virtual widget& insert(widget *);
	virtual widget& set_attr(const std::string&, const std::string&,const std::string &subctrlid = "");
	virtual std::string get_attr(const std::string& name);

public slots:
	void on_click(void);
	void on_change(const QString&);
	void on_change();
	void on_return(void);
	void on_select(void);
};

class qt_button: public qt_widget
{
	QPushButton *wnd;

public:
	qt_button(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string &subctrlid = "");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_label: public qt_widget
{
	QLabel *wnd;
	std::string text_; /**< saved text value */

public:
	qt_label(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid = "");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

//FIXME: replace with textbox with lines=1 in the future
class qt_lineedit: public qt_widget
{
	QLineEdit *wnd;
public:
	qt_lineedit(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid="");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_textbox: public qt_widget
{
	QTextEdit *wnd;

public:
	qt_textbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid = "");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_listbox: public qt_widget
{
Q_OBJECT
	QListBox *wnd;
public slots:
	void on_dbl_click(QListBoxItem*);
public:
	qt_listbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid="");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
	virtual widget& insert(widget *);
};

class qt_combobox: public qt_widget
{
	QComboBox *wnd;

public:
	qt_combobox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid="");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
	virtual widget& insert(widget *);
};

class qt_checkbox: public qt_widget
{
	QCheckBox *wnd;
	std::string text_;
public:
	qt_checkbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid="");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_progressbar: public qt_widget
{
	QProgressBar *wnd;
public:
	qt_progressbar(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid="");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_vbox: public qt_widget
{
	QFrame *wnd;

public:
	qt_vbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid="");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
	virtual widget& insert(widget *);
};

class qt_hbox: public qt_widget
{
	QFrame *wnd;

public:
	qt_hbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid="");
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
	virtual widget& insert(widget *);
};


#endif // DIALOG_QT_HH
