/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef MATCHER_HH
#define MATCHER_HH

#include <command.hh>

#include <vector>
#include <stdexcept>
#include <regex.h>

struct regex_error: public std::runtime_error
{
	regex_error(int, const regex_t&);
};

class matcher
{
	std::string name_re;
	std::vector<std::pair<std::string, std::string> > attr_re;

public:
	bool matches(const command& cmd, context& match) const;

	void clear(void);

	inline matcher&
	operator()(const std::string&);

	inline matcher&
	operator()(const std::string&, const std::string&);

	matcher&
	add(const std::string&);

	matcher&
	add(const std::string&, const std::string&);

	command
	as_command(void) const;
};

matcher&
matcher::operator()(const std::string& re)
{
	return add(re);
}

matcher&
matcher::operator()(const std::string& n_re, const std::string& v_re)
{
	return add(n_re, v_re);
}

#endif // MATCHER_HH
