/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef MODULE_HH
#define MODULE_HH

#include <utils/err.hh>
#include <utils/shared_ptr.hh>
#include <utils/fdstream.hh>

#include <iosfwd>

namespace err
{
	struct module: public general
	{
		module(const std::string& why): general(why) {}
	};

	struct not_running: public module
	{
		not_running(const std::string& why): module(why) {}
	};

	struct io: public module
	{
		io(const std::string& why): module(why) {}
	};
}

struct channel
{
	channel(int in, int out,int err);
	alt::ifdstream is;//out
	alt::ofdstream os;//in
	alt::ifdstream es;//err
};


struct module
{
	module(const std::string& command,bool need_stderr = false);
	module(const std::string& name, const std::string& command,bool need_stderr = false);
	virtual ~module(void);

	bool is_running(void) const;
	void start(const std::string& = "");
	void stop(void);

	const std::string& name(void) const { return name_; }
	void name(const std::string& newname) { name_ = newname; }
	const std::string& command(void) const { return command_; }
	pid_t pid(void) const { return pid_; }

	std::istream& is(void); /**< standart output of the running process */
	std::istream& es(void); /**< standart error output of the running process */
	std::ostream& os(void); /**< standart input of the running process */
	
	void close_os(void); /**< close input stream */
private:
	void startup_io(void);
	void shutdown_io(void);

private:
	std::string name_;
	std::string command_;
	pid_t pid_;
	int in_, out_,err_; // in == stdin of module, out == stdoout
	alt::shared_ptr<channel> io_;
	bool need_stderr_;
};

#endif // MODULE_HH
