/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef PAIR_OPS_HH
#define PAIR_OPS_HH

template <typename A> struct unpair_i
{
	unpair_i(A a): a_(a) {}
	operator A() { return a_; }
	template <typename P> void operator()(P& p) { a_(p.first, p.second); }
private:
	A a_;
};

template <typename A> struct first_i
{
	first_i(A a): a_(a) {}
	operator A() { return a_; }
	template <typename P> void operator()(P& p) { a_(p.first); }
private:
	A a_;
};

template <typename A> struct second_i
{
	second_i(A a): a_(a) {}
	operator A() { return a_; }
	template <typename P> void operator()(P& p) { a_(p.second); }
private:
	A a_;
};

template <typename A> unpair_i<A> unpair(A a) { return unpair_i<A>(a); }
template <typename A> first_i<A> first(A a) { return first_i<A>(a); }
template <typename A> second_i<A> second(A a) { return second_i<A>(a); }

#endif // PAIR_OPS_HH
