/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef PLUGIN_INFO_HH__
#define PLUGIN_INFO_HH__

#include <vector>
#include <string>
#include <map>

#include <module.hh>

typedef std::map<std::string,std::string> cache_type;

struct plugin_info
{
	plugin_info(const std::string& command = ""):
		opened_(false),
		open_mode_(0),
		plugin_(command,true)
	{}

	bool opened_;
	int open_mode_;
	module plugin_; /**< plugin subprocess */

	std::vector<char> buffer_; /**< file content: result of reading from subprocess stdout */
	std::vector<char> err_buffer_; /**< .err file content: result of reading from subprocess stderr */
	cache_type cache_; /**< dir content cache */
};

#endif
